@extends('admin.layout.template')
@section('title', 'Project Details')
@section('content')

<div class="page-content">
    <div class="container-xxl">

<div class="row">
    <!-- Left Column: Project & Customer Details -->
    <div class="col-lg-4">

        <!-- Project Card -->
        <div class="card overflow-hidden mb-3">
            <div class="card-body p-0">
                <div class="bg-primary profile-bg rounded-top p-5 position-relative">
                    <img src="{{ $project['location']['image_full'] ?? 'assets/images/default.png' }}" 
                         alt="Project Image" class="avatar-lg border border-light border-3 rounded-circle position-absolute top-100 start-50 translate-middle">
                </div>
                <div class="mt-5 pt-3 text-center">
                    <h4 class="mb-1">{{ $project['project_name'] ?? '-' }}</h4>
                    <p class="text-muted mb-1">{{ $project['project_number'] ?? '-' }}</p>
                    <span class="badge bg-success">{{ ucfirst($project['status'] ?? 'new') }}</span>
                </div>
            </div>
        </div>

        <!-- Customer Details -->
        <div class="card mb-3">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h4 class="card-title mb-0">Customer Details</h4>
                <span class="badge bg-success-subtle text-success px-2 py-1">Active User</span>
            </div>
            <div class="card-body py-2">
                <div class="table-responsive">
                    <table class="table mb-0">
                        <tbody>
                            <tr>
                                <td class="px-0 fw-semibold">Name:</td>
                                <td class="px-0">{{ $project['customer']['name'] ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td class="px-0 fw-semibold">Phone:</td>
                                <td class="px-0">{{ $project['customer']['phone'] ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td class="px-0 fw-semibold">Address:</td>
                                <td class="px-0">{{ $project['location']['address'] ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td class="px-0 fw-semibold">Type:</td>
                                <td class="px-0">{{ ucfirst($project['project_type'] ?? '-') }}</td>
                            </tr>
                            <tr>
                                <td class="px-0 fw-semibold">Expected Completion:</td>
                                <td class="px-0">{{ $project['expected_completion'] ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td class="px-0 fw-semibold">Measurement By:</td>
                                <td class="px-0">{{ $project['measurement_taken_by'] ?? '-' }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

    <!-- Right Column: Areas & Items -->
    <div class="col-lg-8">
        @foreach($project['areas'] ?? [] as $area)
            <div class="card mb-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">{{ $area['area_name'] ?? 'Area' }}</h4>
                </div>
                <div class="card-body">
                    @if(isset($area['room_image']))
                        <img src="{{ $area['room_image'] }}" class="img-fluid rounded mb-3" alt="Room Image">
                    @endif

             @foreach($area['items'] ?? [] as $item)
    <div class="border-bottom mb-2 pb-2">
        <p><strong>Category:</strong> {{ ucfirst($item['category'] ?? '-') }}</p>

        @if(isset($item['product']))
            <p><strong>Product:</strong> {{ $item['product']['name'] ?? '-' }}</p>
            <p><strong>Material:</strong> {{ $item['product']['material'] ?? '-' }}</p>
            <p><strong>Pattern:</strong> {{ $item['product']['pattern'] ?? '-' }}</p>
        @endif

        @if(isset($item['variant']))
            <p><strong>Variant:</strong> {{ $item['variant']['sku'] ?? '-' }}</p>
            <p><strong>Price:</strong> ₹{{ $item['variant']['mrp'] ?? '0.00' }}</p>
        @endif

        <p><strong>Quantity:</strong> {{ $item['quantity'] ?? '0' }}</p>
    </div>
@endforeach

                </div>
            </div>
        @endforeach
    </div>
</div>

        <a href="{{ route('projects.index') }}" class="btn btn-secondary mt-3">Back to Projects</a>

    </div>
</div>

@endsection
